<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | Bulk Upload final step, Validation of csv, insert in to database     |
// | File name : bulkupload_check.php                                     |
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts Multicart                     |
// +----------------------------------------------------------------------+
// | Author: Binu Chandran<binu.chandran@armiasystems.com>	          |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems, Inc and iScripts.com (C) 2011              |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+
?>
<?php
/*
* Include necessary files
*/
include "../includes/config.php";
include "../includes/session.php";
include "../includes/functions.php";
include_once('../classes/cls_utils.php');
include_once('../classes/cls_store.php');
include_once('../classes/cls_products.php');
/*
* Checking for admin login
* If not logged in, will redirect to login
*/
if(isset( $_SESSION["sess_adminname"]) and $_SESSION["sess_adminname"]!= ""){
$adminname = $_SESSION["sess_adminname"];
}else{
header("Location:login.php");
exit;
}
//echo "qqq";
/**
* Method to add product option
* @global type $tableprefix
* @param type $newProduct
* @param type $productID
* @param type $default
*/
function addProductOption($newProduct, $productID, $default='NO',$pdo)
{
global $tableprefix;
//Adding product option
//include_once('../pdo/pdoclass.php');

$options =  array("product_id"=>$productID,
                    "additional_price"=>$newProduct['additional_price'],
                    "image_big"=>$newProduct['big_image'],
                    "product_stock"=>$newProduct['product_stock'],
                    "reorder_level"=>$newProduct['reorder_level'],
                    "product_shipping_weight"=>$newProduct['shipping_weight'],
                    "default_option"=>$default,
                    "discount"=>$newProduct['discount'],
                    "discount_description"=>$newProduct['discount_description'],
                    "product_width"=>$newProduct['product_width'],
                    "product_height"=>$newProduct['product_height'],
                    "product_length"=>$newProduct['product_length']);

//echopre($options);

 $productOptionID  = $pdo->insert($tableprefix."product_options",$options)->lastInsertId();


if($productOptionID!='')
{
if($productOptionID > 0)
{
/*
* Adding options
*/
if(isset($newProduct['options']))
{
if(!empty($newProduct['options']))
{
foreach($newProduct['options'] as $optID => $optValue)
{

    $productopts = array("product_option_id"=>$productOptionID,
                           "option_id"=>$optID,
                            "value"=>$optValue);

    $insOptQuery  = $pdo->insert($tableprefix."product_option_values",$productopts)->lastInsertId();

}
}
}
}
}
}

function customfgetcsv(&$handle, $length, $separator = ','){
if(($buffer = fgets($handle, $length)) !== false) {
$value = (fgetcsv($file, 0, ','));
$buffer = preg_replace('/[ ,]+/', ' ', trim($buffer));
$a=explode( $separator, iconv( "CP1251", "UTF-8", $buffer ) );
//print_r($a);
return $a;
//return iconv( "CP1251", "UTF-8", $buffer );
}
return false;
}

/**
* Method to rearrange csv data with schema
* @global type $csvSchema
* @global type $inventory
*/
function rearrangeCSVData()
{
global $csvSchema;
global $inventory;
foreach($inventory as $key => $productItem)
{
foreach($productItem as $keyPrd => $product)
{
if($keyPrd == 'option_product')
{
$inventory1 = $product;
if(is_array($inventory1) && !empty($inventory1))
{
foreach($inventory1 as $key1 => $productItem1)
{
    foreach($productItem1 as $keyPrd1 => $product1)
    {
        $inventory[$key][$keyPrd][$key1][$keyPrd1] =  $inventory[$key][$keyPrd][$key1][$csvSchema[$keyPrd1]];
    }
}
}
}
else
{
$inventory[$key][$keyPrd] = $inventory[$key][$csvSchema[$keyPrd]];
}
}
}

}

//echo "aaaa";

/*
* Read csv file
*/
$csvfilename    =   $_GET['file'];
$filepath       =   "../csv/$csvfilename";
$sampleFilepath =   "../csv/sample.csv";
/*
* Assign seller id
*/

$sellerid       =   $_GET['sellerid'];
$publishStatus  =   $_GET['publishstatus'];
$publishTime    =   $_GET['publishtime'];
$sellertimezone =   $_GET['sellertimezone'];
/*
* chechk sample csv file exixts or not
*/

//mb_detect_encoding($str, mb_detect_order(), TRUE);

if(file_exists($sampleFilepath))
{
//header("Cache-Control: public");
//header("Content-Type: application/octet-stream");
//header("Content-Type: text/csv; charset=utf-8");
$fcontents = file($sampleFilepath);
$headers=str_replace('"',"",$fcontents[0]);
$sampleArray=explode(",",$headers);

}


/*
* check file exists
*/
if(file_exists($filepath))
{
//header("Cache-Control: public");
//header("Content-Type: application/octet-stream");
//header("Content-Type: text/csv; charset=utf-8");
$fcontents  =   file($filepath);
$header     =   str_replace('"', "", $fcontents[0]);

$listArray  =   explode(",", $header);
//print_r($listArray);
//exit();
}

$message    =   "";
$flag       =   "true";
/*
* Post back
*/

if(isset($_POST['btnSave']))
{
$csvfiles=$_POST['csvfilename'];
$csvFile="../csv/$csvfiles";
$sellerid=$_POST['sellerid'];
/*
* Initialize CSV Schema
*/
$csvSchema  = array('product_name'          => $_POST['labelsproduct_name'],
        'product_category'      => $_POST['labelsproduct_category'],
        'product_code'          => $_POST['labelsproduct_code'],
        'product_description'   => $_POST['labelsproduct_description'],
        'product_price'         => $_POST['labelsproduct_price'],
        'options'               => $_POST['labelsoptions'],
        'additional_price'      => $_POST['labelsadditional_price'],
        'product_stock'         => $_POST['labelsproduct_stock'],
        'reorder_level'         => $_POST['labelsreorder_level'],
        'big_image'             => $_POST['labelsbig_image'],
        'more_images'           => $_POST['labelsmore_images'],
        'discount'              => $_POST['labelsdiscount'],
        'discount_description'  => $_POST['labelsdiscount_description'],
        'shipping_weight'       => $_POST['labelsshipping_weight'],
        'product_length'        => $_POST['labelsproduct_length'],
        'product_width'         => $_POST['labelsproduct_width'],
        'product_height'        => $_POST['labelsproduct_height'],
        'allow_free_shipping'   => $_POST['labelsallow_free_shipping'],
        'product_tags'          => $_POST['labelsproduct_tags'],
        'payment_status'        => 'COMPLETED'
);
/*
* Validating mandatory fields
*/
if( $csvSchema['product_name'] == '' )
{
$message .= SELECT_FN_PDT_NAME."<br>";
}
if( $csvSchema['product_category'] == '' )
{
$message .= SELECT_FN_PDT_CAT."<br>";
}

if( $csvSchema['product_price'] == '' )
{
$message .= SELECT_FN_PDT_PRICE."<br>";
}
if( $csvSchema['product_description'] == '' )
{
$message .= SELECT_FN_PDT_DESC."<br>";
}
/*
* Read and processing CSV File
*/
if(file_exists($csvFile))
{
$maxlinelength  = 10000;
$fh             = fopen($csvFile, 'r');
$lines          = count(file($csvFile))-1;
$firstline      = fgetcsv($fh, $maxlinelength,',');
$cols           = count($firstline);
$row            = 1;
$inventory      = array();
$addedProducts  = array();


/*
* Read line by line of CSV*/

//while ( ($nextline = customfgetcsv($fh, $maxlinelength)) !== FALSE )
while ( ($nextline = fgetcsv($fh, $maxlinelength,',')) !== FALSE )
{
// echopre1($nextline);
/*
* Initialize variables
*/


$product            = array();
$categorySelected   = 0;
$productName        = '';
$options            = array();
//print_r($nextline);  exit;
foreach($nextline as $key => $productRow)
{
/*$productRow = iconv("utf-8", "ascii//TRANSLIT//IGNORE", $productRow);
$productRow =  preg_replace("/^'|[^A-Za-z0-9\s-]|'$/", '', $productRow); // lets remove utf-8 special characters except blank spaces                  */
$product[$sampleArray[$key]]    = $productRow;

//iconv("UTF-16", "UTF-8", $productRow) . "<br />\n";
//echo  $productRow;
//   exit();
/*
* Validations start here
*/
$categoryError = false;

switch($sampleArray[$key])
{
    case 'product_name':
        if($productRow == '')
        {
            $message .= EMPTY_FN_PDT_NAME." " . $row . ".<br>";
        }
        else
        {
            $productName = $productRow;
        }
    break;
    case 'product_category': //echo  $productRow."<br>";
        if($productRow == '')
        {
            $message .= EMPTY_FN_PDT_CAT." " . $row . ".<br>";
            $categoryError = true;
        }
        else
        {
        	//echo iconv(mb_detect_encoding($productRow, mb_detect_order(), true), "UTF-8", $productRow);

               $catQuery    =   "SELECT category_id FROM ".$tableprefix."categories
                               WHERE category_name =:categoryname";

                $rs = $pdo->pdoQuery($catQuery,array('categoryname'=>$productRow))->result();


                $numrows = count($rs);

                if(empty($rs))
                {
                    $message .= EXIST_FN_PDT_CAT." " . $row . ".<br>";
                    $categoryError = true;
                }
                else
                {
                         $pRow = $rs;


                          if($pRow['category_id']> 0)
                             {
                                 $categorySelected = $pRow['category_id'];
                             }



              $catQuery =   "SELECT COUNT(category_id) as total FROM ".$tableprefix."categories
                                   WHERE category_name =:cname AND category_id IN (SELECT parent_id FROM ".$tableprefix."categories)";

                $result = $pdo->pdoQuery($catQuery,array('cname'=>$productRow))->result();


                    if(!empty($result))
                    {
                        $pRow1 = (object) $result;

                        if($pRow1->total > 0)
                        {

                            $message .= FN_PDT_LEAF_CAT." " . $row . ".<br>";
                            $categoryError = true;
                            $categorySelected = 0;
                        }

                    }
                }


        }
        if($categorySelected > 0)
        {
            $product[$sampleArray[$key]]    = $categorySelected;
        }

    break;
    case 'product_description':
        if($productRow == '')
        {
            $message .= EXIST_FN_PDT_DESC." " . $row . ".<br>";
        }
    break;
    case 'product_price':
        if(($productRow <= 0))
        {
            $message .= FN_PDT_PRICE_GREAT." " . $row . ".<br>";
        }
    break;
    case 'options':

        if($categoryError == false && $categorySelected > 0)
        {
            if($productRow != '')
            {
                $optionsCSV = explode(';', $productRow);
                if(!empty($optionsCSV))
                {
                    foreach($optionsCSV as $optionCSV)
                    {
                        if($optionCSV != '')
                        {
                            $optionsValues = explode('=', $optionCSV);
                            if(!empty($optionsValues))
                            {
                                $optionName  = isset($optionsValues[0]) ? trim($optionsValues[0]) : '';
                                $optionValue = isset($optionsValues[1]) ? trim($optionsValues[1]) : '';

                                if($optionName != '' && $optionValue != '')
                                {
                                    $optQuery = "SELECT option_id
                                                   FROM ".$tableprefix."options
                                                  WHERE option_name=:optionname ";

                         $optResult = $pdo->pdoQuery($optQuery,array('optionname'=>$optionName))->result();

                              if(!empty($optResult)) {
                                    if(count($optResult) > 0 )
                                    {
                                        $optRow = (object) $optResult;
                                        if($optRow->option_id > 0)
                                        {


                                            $optAssQuery = "SELECT category_option_id
                                                   FROM ".$tableprefix."category_options
                                                  WHERE option_id =:optionid
                                                      AND category_id =:categoryid";
                                $optAssResult = $pdo->pdoQuery($optAssQuery,array('optionid'=>$optRow->option_id,'categoryid'=>$categorySelected))->result();

                                       if(!empty($optAssResult)) {
                                                if(count($optAssResult) > 0)
                                                {
                                                    $optAssRow = (object) $optAssResult;
                                                    
                                                    $optionNew[$optRow->option_id] = $optionsValues[1];
                                                    
                                                    if($optAssRow->category_option_id > 0)
                                                    {
                                                        //$options[] = array($optRow->option_id => $optionValue);
                                                        $options[$optRow->option_id] = $optionValue;

                                                    }
                                                }
                                                else
                                                {
                                                    $message .= FN_OPTION." '" . $optionName . "'  ".FN_NOT_ASSIGNED . $row . ".<br>";
                                                }
                                        }
                                        }
                                    }
                                    else
                                    {
                                        $message .= FN_OPTION." '" . $optionName . "' ".FN_NOT_EXIST." " . $row . ".<br>";
                                    }
                               }
                                }
                            }
                        }
                    }
                }
            }
        }

        if(!empty($options))
        {
            $product[$sampleArray[$key]]    = $options;
        }
    break;
    case 'product_code':
        if($productRow != '' && $categoryError == false && $categorySelected > 0)
        {


          $qry = "SELECT product_code
                      FROM " . $tableprefix . "products
                     WHERE product_code='" . addslashes($productRow) . "'
                       AND product_artist_id='".$sellerid."'
                       AND product_category = '".addslashes($categorySelected)."'  ";

            $resCode= $pdo->pdoQuery($qry,'')->result();

         if(!empty($resCode)) {
                if (count($resCode) > 0 )
                {

                    $message .= FN_PDT_CODE_EXIST." " . $row . ".<br>";
                }
             }
        }

    break;
    case 'product_stock':
        if(!($productRow > 0))
        {
            $message .= FN_PDT_STOCK." " . $row . ".<br>";
        }
        else
        {
            $stock = $productRow;
        }
    break;
    case 'reorder_level':
        if($stock > 0 && ($productRow > $stock))
        {
            $message .= FN_PDT_STOCK." " . $row . ".<br>";
        }
    break;
    case 'more_images':
        if($productRow != '')
        {
            $moreImagesCSV = explode(';', $productRow);
            if(!empty($moreImagesCSV))
            {
                $product[$sampleArray[$key]]    = $moreImagesCSV;
            }
        }
    break;
    case 'shipping_weight':
        if(!($productRow > 0))
        {
            $message .= FN_PDT_SHIP." " . $row . ".<br>";
        }
    break;
    case 'product_length':
        if(!($productRow > 0))
        {
            $message .= FN_PDT_LENGTH." " . $row . ".<br>";
        }
    break;
    case 'product_width':
        if(!($productRow > 0))
        {
            $message .= FN_PDT_WIDTH." " . $row . ".<br>";
        }
    break;
    case 'product_height':
        if(!($productRow > 0))
        {
            $message .= FN_PDT_HEIGTH." " . $row . ".<br>";
        }
    break;
    /*case 'allow_free_shipping':
        if($productRow == '')
        {
            $message .= EXIST_FN_PDT_SHIPPING_STATUS." " . $row . ".<br>";
        }
    break;
    case 'allow_subscription':
        if($productRow == '')
        {
            $message .= EXIST_FN_PDT_SHIPPING_STATUS." " . $row . ".<br>";
        }
    break;
    case 'subscription_mode':
        if($productRow == '')
        {
            $message .= EXIST_FN_PDT_SUBSCRIPTION_MODE." " . $row . ".<br>";
        }
    break;
    case 'product_tags':
        if($productRow == '')
        {
            $message .= EXIST_FN_PDT_PRODUCT_TAG." " . $row . ".<br>";
        }
    break;*/
}
/*
* Validations end here
*/
}

/*
* Checking for product option
*/
$isOption = false;
if($productName != '')
{
$productNameKey = strtolower($productName);
if(array_key_exists($productNameKey, $addedProducts))
{
    if($addedProducts[$productNameKey] == $categorySelected && !empty($options))
    {
        foreach($inventory as $invKey => $invProduct)
        {
            if($invProduct['product_name'] == $productName)
            {
                $inventory[$invKey]['option_product'][] = $product;
                $isOption = true;
            }
        }
    }
}
else
{
    $addedProducts[$productNameKey] = $categorySelected;
}
}
if(!$isOption)
{
$inventory[] = $product;
}
$row++;

}
//echopre1($inventory);
}
$addedCount = 0;
/*
* Start to adding values after validation
*/
if($message == '')
{
if(!empty($inventory))
{
/*
* Rearrange csv data
*/
rearrangeCSVData();
///echopre1($inventory);
$approveProducts = getSettingsValue('approve_products') == 1 ? 'Y' : 'N';
foreach($inventory as $newProduct)
{
//Generate Alias name for product
$aliasname = Utils::generateAlias($tableprefix . "products", $newProduct['product_name']);

 // Pass default values for shiping and subscription if values are empty in csv sheet

if($newProduct['allow_free_shipping']=='')
    {
            $newProduct['allow_free_shipping']  =   'N';
    }
    if($newProduct['allow_subscription']=='')
    {
            $newProduct['allow_subscription']  =   'N';
    }
    if($newProduct['subscription_mode']=='')
    {
            $newProduct['subscription_mode']  =   'Monthly';
    }

//Get Seller Vacation mode settings
 //default published if settings disabled

if(getSettingsValue('enable_product_scheduled_publishing')=='N')
{
    $publishStatus    = 'Y';
}


$sellerObj  =    Store::get_seller_account_info($sellerid);
$seller_vacation_mode     ='N';
if($sellerObj->status==SUCCESS)
        {
            $sellerObjVal                       =   $sellerObj->data;
            $seller_vacation_mode		    =	$sellerObjVal->is_vacation_mode;

        }

        $date =  date('Y-m-d');

$data  =  array("product_name"=>$newProduct['product_name'],
                "product_price"=>$newProduct['product_price'],
                "product_code"=>$newProduct['product_code'],
                "product_description"=>$newProduct['product_description'],
                "product_category"=>$newProduct['product_category'],
                "product_artist_id"=>$sellerid,
                "allow_free_shipping"=>$newProduct['allow_free_shipping'],
                "product_tags"=>$newProduct['product_tags'],
                "publish_status"=>$publishStatus,
                "publish_scheduled_date"=>$publishTime,
                "publish_timezone"=>$sellertimezone,
                "date_added"=>$date,
                "deleted"=>'N',
                "featured"=>'N',
                "vdigital_product"=>'N',
                "vapproved"=>$approveProducts,
                "seller_vacation_mode"=>$seller_vacation_mode,
                "alias"=>$aliasname,
                'payment_status'=> 'COMPLETED');

//Adding product
 $productID  = $pdo->insert($tableprefix."products",$data)->lastInsertId();


if($productID!='')
{


    // check product options already added then remove and insert again // this is not a reguar case


$sqlOptionExistsCheck   = "SELECT product_option_id  FROM " . $tableprefix . "product_options where product_id =:productid AND default_option ='YES' ";

$resultOptionSql = $pdo->pdoQuery($sqlOptionExistsCheck,array('productid'=>$productID))->results();


if(!empty($resultOptionSql))
{
    //$reultObj               =    mysql_fetch_object($resultOptionSql);
    //$productExistOptionId   =    $reultObj->product_option_id;

    // remove options if exists

    foreach($resultOptionSql as $product_options_row)  {
        $productOptionsArr[]  = $product_options_row['product_option_id'];
    }

    $productExistOptionId = implode("','",$productOptionsArr);
    //echo $productExistOptionId;



    $sql_options = "DELETE FROM ".$tableprefix."product_options WHERE product_option_id IN ('".$productExistOptionId."') ";

    $del_options= $pdo->pdoQuery($sql_options ,'');



}

if($optionNew){
                   $newProduct['options'] = $optionNew;
                        }

                        
                  
                        
    if($productID > 0)
    {
        
             // echopre1($newProduct);
        //Adding product Option
    	//echo '<pre>'; print_r($newProduct); echo '</pre>'; exit;
        addProductOption($newProduct, $productID, 'YES',$pdo);

    }
    if(isset($newProduct['option_product']))
    {
        if(!empty($newProduct['option_product']))
        {
            foreach($newProduct['option_product'] as $newOption)
            {
              // echo '<pre>'; print_r($newOption); echo '</pre>';
            	addProductOption($newOption, $productID,'',$pdo);
            }
        }
    }
    if(isset($newProduct['more_images']))
    {
        if(!empty($newProduct['more_images']))
        {
            foreach($newProduct['more_images'] as $moreImage)
            {

                 $optimages = array("nimage_productid"=>$productID,
                                    "vimage_name"=>$moreImage);

                  $imageid  = $pdo->insert($tableprefix."product_view_images",$optimages)->lastInsertId();
            }
        }
    }
//*****************************************Multicart Scalabilty Changes**********************************
if(getSettingsValue('enable_scalability_settings')=='Y')
{
$objDefaultOptionVo                                     =    new stdClass();
$objOptionVo                                            =    Products::getProduct_Default_Option_Values($productID);

$objDefaultOptionVo->default_image_small                =   $objOptionVo->image_small;
$objDefaultOptionVo->default_additional_price           =   $objOptionVo->additional_price;
$objDefaultOptionVo->default_shipping_weight            =   $objOptionVo->product_shipping_weight;
$objDefaultOptionVo->default_discount                   =   $objOptionVo->discount;
$objDefaultOptionVo->default_discount_description       =   $objOptionVo->discount_description;
$objDefaultOptionVo->default_option_id                  =   $objOptionVo->product_option_id;
$objDefaultOptionVo->product_id                         =   $productID;

// Save default option values to product table
$productinfoUpdate                                      =   Products::updateProduct_Default_Option_Value($objDefaultOptionVo);

}


//*****************************************Multicart Scalabilty Changes**********************************

}
$addedCount++;
}
}
}
/*
* Redirect to product list after adding products
*/
if($addedCount > 0)
{
header('location:listProducts.php?message='. $addedCount . ' '.FN_PDT_UPLOAD);
exit;
}
} // end button post check
include "../includes/htmltop.php";
?>
<script language="Javascript">
$(document).ready(function() {

$("#btnBack").click(function (){
window.location.href='bulkupload.php?rghtMenu=rghtMenu5&displayDiv=Product Management';
});
});
</script>
<body>
<center>
<div align="left" id="layout">
<!--header area start -->
<?php include_once("../includes/topheader_admin.php"); ?>
<!--header area end -->
<div align="left" class="main_body">
<!--main body start -->
<?php include_once("../includes/admintopmenu.php"); ?>
<div align="left" class="content_area">
<!--content area start -->
<div align="left"><?php //include("../includes/bulkuploadmenu.php");?></div>
<div align="left" class="page_title"><?php echo BULK_PRO_UPLOAD;?></div>
<div align="center" class="text_information grey_tr"><?php echo $message?></div>
<br>
<div align="left">
	<form action="" method="post" enctype="multipart/form-data" name="frmProductBulk" >
	<?php if($recordsper==0 && $flag=="true")
	{ // display upload if error free
	?>
	<table width="98%" border="0" cellpadding="8" cellspacing="4" class="manage_table">
	<tr>
	  <td colspan="3"><?php echo FN_PDT_IMPORT_FIELDS;?></td>
	  </tr>
	<tr><td width="34%" height="37"><strong><?php echo LINK_IMP_FIELD;?></strong></td>
	  <td width="2%">&nbsp;</td>
	  <td width="64%">&nbsp;</td>
	</tr>
	<?php //print_r($sampleArray); exit;
	foreach($sampleArray as $bulkvalue)
	{
                                $bulkvalue = trim($bulkvalue);
		$caption = str_replace("_"," ",$bulkvalue);
		$filedArray='labels'.$bulkvalue;
	?>
	<tr>
	  <td><?php echo MATCH;?> '<?php echo $caption;?> ' <?php echo WITH;?> </td>
	  <td>&nbsp;<?php if($bulkvalue=="product_name" ||  $bulkvalue=="product_category" || $bulkvalue=="product_price"  ||  $bulkvalue=="product_description") { ?><span class="required">*</span><?php } ?></td>
	  <td><select name="labels<?php echo $bulkvalue;?>">
	  <option value=""><?php echo IGNORE;?></option>
	  <?php
	  	foreach($listArray as $bulkkeys)
		{
			$textName = str_replace("_"," ",$bulkkeys);
		?>
		<option value="<?php echo $bulkkeys?>" <?php if(trim($bulkvalue)==trim($bulkkeys)) { echo "selected" ; } ?>><?php echo $textName;?> </option>
		<?php
		}
		?>
      </select>
      <input type="hidden" name="csvfilename" value="<?php echo $csvfilename;?>">
      <input type="hidden" name="sellerid" value="<?php echo $sellerid;?>"></td>
	  </tr>
	 <?php } ?>
	<tr>
	  <td>&nbsp;</td>
	  <td>&nbsp;</td>
	  <td>&nbsp;<input type="button" name="btnBack"  id ="btnBack" value="<?php echo BACK;?>" class="button"> &nbsp;<input type="submit" name="btnSave" value="<?php echo NEXT;?>" class="button"> </td>
	  </tr>
	</table>
<?php } // end if ?>

	<?php if($recordsper>0  && $flag=="false")
	{ // check products uploaded or not
	?>
	<table width="98%" border="0" cellpadding="8" cellspacing="4" class="manage_table">
	<tr>
	  <td colspan="3" align="left" class="text_information"><?php echo $recordsper?> <?php echo PRODUCT_SAVED;?></td>
	  </tr>
	<?php if(is_array($parray) && count($parray)>0){ ?>
	  <tr>
	  <td colspan="3" align="left" class="text_information"><?php echo PROD_ALREADY_EXIST;?>!. </td>
	  </tr>
	  <?php
	  $dd=1;
	  foreach($parray as $pnames)
	  {
	  ?>
	   <tr>
	  <td colspan="3" align="left"><?php echo $dd. ")  ". $pnames;?></td>
	  </tr>
	  <?php
	  	$dd++;
	      } // end for each
	   } // end if error
 ?>
	    <tr>
	  <td width="22%" height="50" align="left"><input type="button" name="btnBack" value="<?php echo FN_BACK_UPLOAD_BTN;?>" class="button" onClick="window.location.href='bulkupload.php'"></td>
	  <td width="30%" height="50" align="left"><input type="button" name="btnNext" value="<?php echo FN_CONTINUE_BTN;?>" class="button" onClick="window.location.href='bulkimageupload.php?sellerid=<?php echo $sellerid;?>'"></td>
	  <td width="48%" height="50" align="left">&nbsp;</td>
	 </tr>

	  </table>

	<?php }  // end if ?>

	<?php if($recordsper==0 && $flag=="false")
	{ // check products uploaded or not
	?>
	<table width="98%" border="0" cellpadding="8" cellspacing="4" class="manage_table">
	<tr>
	  <td colspan="3" align="left" class="text_information"><?php echo $recordsper;?> <?php echo FN_PDT_SAVED;?></td>
	  </tr>
	  <?php if(is_array($parray) && count($parray)>0){ ?>
	  <tr>
	  <td colspan="3" align="left" class="text_information"><?php echo FN_PDT_SAVE_FAILED;?>. </td>
	  </tr>
	   <?php
	   $num=1;
	  	 foreach($parray as $value)
	 		 {
	  ?>
	   <tr>
	  <td colspan="3" align="left"><?php echo $num. ")  ". $value;?> </td>
	  </tr>
	  <?php
	  		$num++;
	      } // end for each
		 } // end if array check
	?>

	 <tr>
	  <td width="43%" height="50" align="left"><input type="button" name="btnBack" value="<?php echo FN_BACK_UPLOAD_BTN;?>" class="button" onClick="window.location.href='bulkupload.php'"></td>
	  <td width="46%" height="50" align="left">&nbsp;</td>
	  <td width="11%" height="50" align="left">&nbsp;</td>
	 </tr>
	  </table>
	<?php
	        }  // end if ?>

	<?php if($recordsper>0 && $flag=="true")
	{ // check products uploaded or not
	?>
	<table width="98%" border="0" cellpadding="8" cellspacing="4" class="manage_table">
	<tr>
	  <td colspan="3" align="left" class="text_information"><?php echo $recordsper;?> <?php echo FN_PDT_SAVED;?></td>
	  </tr>
	  <?php if(is_array($productsSavedArray) && count($productsSavedArray)>0){ ?>
	  <tr>
	  <td colspan="3" align="left" class="text_information"><?php echo FOLLWNG_PRO_SAVED_SUCC;?> !. </td>
	  </tr>
	   <?php
	   $nums=1;
	  	 foreach($productsSavedArray as $products)
	 		 {
	  ?>
	   <tr>
	  <td colspan="3" align="left"><?php echo $nums. ")  ". $products;?> </td>
	  </tr>
	  <?php
	  		$nums++;
	      } // end for each
		 } // end if array check
	?>
	  <tr>
	  <td width="19%" height="50" align="left"><input type="button" name="btnBack" value="<?php echo FN_BACK_UPLOAD_BTN;?>" class="button" onClick="window.location.href='bulkupload.php'"></td>
	  <td width="33%" height="50" align="left"><input type="button" name="btnNext" value="<?php echo FN_CONTINUE_BTN;?>" class="button" onClick="window.location.href='bulkimageupload.php?sellerid=<?php echo $sellerid;?>'"></td>
	  <td width="48%" height="50" align="left">&nbsp;</td>
	 </tr>
	  </table>

	<?php }  // end if ?>

  </form>


  </div>


<!--content area end-->

</div>


<div align="left" class="clear_float"><img src="<?php echo $imagefolder;?>/clear.gif" alt="" width="1" height="1" /></div>
<!--main body end -->
</div>


<?php include "../includes/footer.php"; ?>
